<?php
/**
 * Menu Location Class
 *
 * PHP Version 7
 *
 * @category Mtc\Menus
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus;

use Illuminate\Database\Eloquent\Model;

/**
 * Menu Location object.
 * Used to link navigation locations and menus.
 *
 * @category Mtc\Menus
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class MenuLocation extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'location',
        'title'
    ];

    /**
     * Get the related Menu
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function menu()
    {
        return $this->belongsTo(Menu::class, 'menu_id');
    }

}
