<?php
/**
 * Event Service Provider for Menus
 *
 * PHP Version 7
 *
 * @category Mtc\Menus\Providers
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Events\Admin\MenuLoading;
use Mtc\Core\Admin\Menu as AdminMenu;
use Mtc\Core\Admin\Tab;
use Mtc\Menus\Menu;

/**
 * Connect the Menu Events to Laravel
 *
 * @category Mtc\Menus\Providers
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class EventServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        // fetch the menu on site - called from a template menus::public.menu
        Event::listen(
            'menu.load', function ($location_tag, $depth = 1) {
                return Menu::loadMenufromTag($location_tag, $depth);
        });

        // Admin Navigation Menu construct
        Event::listen(
            MenuLoading::class, function () {
                AdminMenu::addMenu(
                    'management',
                    'Navigation',
                    '',
                    'navigation',
                    'glyphicon glyphicon-list');

                AdminMenu::addSubMenu(
                    'navigation',
                    'Manage Navigation Menus',
                    '',
                    route('menus.admin.menus.index'),
                    'navigation');
            }
        );

        // Edit page - add tabs for navigation
        Event::listen('tabs.loading: ' . Menu::class,
            function($model) {
                return [
                    new Tab(
                        'menus.index',
                        'Manage Menus',
                        !empty($model->id) ? route('menus.admin.menus.edit', $model) : route('menus.admin.menus.index')
                    ),
                    new Tab(
                        'menus.locations',
                        'Menu Locations',
                        route('menus.admin.locations.index')
                    ),
                ];
            }
        );

        // Listen to Menu section fulfilment - allow adding custom sections for Menu population
        Event::listen('Mtc\Menus\Events\Admin\GetMenuSections', 'Mtc\Menus\Listeners\CustomMenuSection');
    }
}
