<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menus', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('parent_id')
                ->nullable()
                ->index()
                ->unsigned();
            $table->integer('lft')
                ->unsigned();
            $table->integer('rgt')
                ->unsigned();
            $table->integer('depth')
                ->unsigned();
            $table->integer('node_id')
                ->nullable()
                ->unsigned()
                ->index();
            $table->boolean('lock_edit')->default(0)->index();
            $table->boolean('auto_load_children')->default(0)->index();
            $table->string('title');
            $table->string('url')->index();
            $table->string('type');
            $table->string('status', 20)->default('draft');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
