<?php

namespace Mtc\Menus\Listeners;

use Mtc\Core\Node;
use Mtc\Menus\Menu;

/**
 * Update menu entries that are locked and linked to a Node
 *
 * @category Mtc\Menus\Listeners
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class UpdateMenuEntry
{
    /**
     * Handle the event.
     * Update menu entries that are locked and linked to a Node
     *
     * @param Node $node node being updated
     */
    public function handle($node)
    {
        Menu::query()
            ->where('type', $node->nodeable_type)
            ->where('node_id', $node->id)
            ->where('lock_edit', 1)
            ->update([
                'url' => $node->url,
                'title' => $node->title
            ]);
    }
}