<?php
/**
 * Class AddTranslationsToMenus
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddTranslationsToMenus
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2018-01-24
 */
class AddTranslationsToMenus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('menus', function (Blueprint $table) {
            $table->text('title')->change();
            $table->boolean('translatable');
            $table->integer('depth')->nullable()->change();
            $table->string('url')->nullable()->change();
            $table->string('type')->nullable()->change();
        });

        Schema::table('menu_locations', function (Blueprint $table) {
            $table->integer('menu_id')->nullable()->change();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('menus', function($table) {
            $table->string('title')->change();
        });
    }
}
