@extends('core::layouts.admin')

@section('title',  'Manage ' . ucfirst($title))

@section('content')

    @include('core::admin.builder.partials.tabs')

    <form method="POST" action="{{ $form_action }}">

        @if (!empty($item->id))
            <div class="clearfix">
                <div class="col-lg-4 col-md-12 no-left-padding">
                    @include('core::admin.builder.partials.node')

                    <div class="well">
                        {!!
                            Mtc\Core\Form::input([
                                'label' => 'menus::text.css_class',
                                'field_name' => 'css_class',
                                'id' => 'css_class',
                                'name' => 'item[css_class]',
                                'placeholder' => 'menus::text.css_class_placeholder',
                                'old_value' => 'item.css_class',
                                'object' => $item
                            ])
                        !!}
                    </div>
                </div>
                <div class="well col-lg-8 col-md-12" v-cloak>

                    <h4>{{ __('menus::text.menu_items') }}</h4>
                    <p>{{ __('menus::text.menu_items_intro') }}</p>

                    <menu-tree id="{{ $item->id }}" :types="{{ json_encode($types) }}"></menu-tree>
                </div>
            </div>
        @else
            @include('core::admin.builder.partials.node')
        @endif
        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success">Save
            </button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">Back to Top</a>
            </div>
        </div>

        {{ method_field($form_method) }}
        {{ csrf_field() }}
    </form>
@endsection
