<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method.
 *
 * PHP Version 7
 *
 * @category Mtc\Menus
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */


$router->group(
    [
        'prefix' => 'admin',
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'menus.admin.'
    ],
    function($router) {
        $router->post('menus/change_parent', Admin\MenuController::class . '@changeParent')->name('change_parent');
        $router->get('menus/list', Admin\MenuController::class . '@list')->name('list');
        $router->post('menus/update_order', Admin\MenuController::class . '@updateOrder')->name('reorder');
        $router->post('menus/process', Admin\MenuController::class . '@process')->name('process');
        $router->resource('menus', Admin\MenuController::class);

        $router->get('list_locations', Admin\LocationController::class. '@list')->name('list_locations');
        $router->post('locations/process', Admin\LocationController::class. '@process')->name('location.process');
        $router->resource('locations', Admin\LocationController::class);
    }
);