<?php
/**
 * StoreMenu Request
 *
 * PHP Version 7
 *
 * @category Mtc\Menus\Http\Requests\Admin
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Determine that data for a menu is all valid before input.
 *
 * @category Mtc\Menus\Http\Requests\Admin
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StoreMenu extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'node.title' => 'required|max:255',
        ];
    }
}
