<?php

namespace Mtc\Menus\Listeners;

use Mtc\Core\Node;
use Mtc\Menus\Menu;

/**
 * Remove menu entry that is linked to a Node once node is deleted
 *
 * @category Mtc\Menus\Listeners
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class RemoveMenuEntry
{
    /**
     * Handle the event.
     * Remove menu entries of this node type and ID
     *
     * @param Node $node node being updated
     */
    public function handle($node)
    {
        Menu::query()
            ->where('type', $node->nodeable_type)
            ->where('node_id', $node->id)
            ->where('lock_edit', 1)
            ->delete();
    }
}