<?php
/**
 * Menu Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Menus\Providers
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\Menus\Menu;

/**
 * Connect the Menus Provider to Laravel
 *
 * @category Mtc\Menus\Providers
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class MenuServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {

        if (!defined('MENUS_PATH')) {
            define('MENUS_PATH', dirname(dirname(__DIR__)) . '/');
        }

        $this->publishes([
            __DIR__ . '/../../database/seeds/' => database_path('seeds')
        ], 'seeds');

    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'menus');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        $this->loadTranslationsFrom(__DIR__ . '/../..//resources/lang', 'menus');
    }

    /**
     * Define the route model bindings.
     *
     * @return void
     */
    protected function defineRouteBindings()
    {
        Route::model('menu', Menu::class);
    }
    /**
     * Define the routes.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        $this->defineRouteBindings();

        /**
         * If the routes have not been cached, we will include them in a route group
         * so that all of the routes will be conveniently registered to the given
         * controller namespace. After that we will load the Core routes file.
         */
        if (! $this->app->routesAreCached()) {
            Route::group(
                ['namespace' => 'Mtc\Menus\Http\Controllers'],
                function ($router) {
                    $path = realpath(MENUS_PATH . '/routes');
                    foreach (glob("{$path}/*.php") as $file) {
                        include $file;
                    }
                }
            );
        }
    }

}
