<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsletterListEmailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('newsletter_list_emails', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('list_id')->index();
            $table->string('email');
            $table->timestamps();
            $table->foreign('list_id')->references('id')->on('newsletter_lists');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('newsletter_list_emails');
    }
}
