<h3>{{ trans('newsletter::titles.list') }}</h3>

<div class="form-group">
    <label for="name" class="control-label">
        {{ trans('fields.name') }}
    </label>
    <div>
        <input type="text"
               class="form-control"
               name="name"
               id="name"
               placeholder="{{ trans('fields.name') }}"
               value="{{ Request::old('name', $item->name) }}"
        />
        @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
    </div>
</div>

<div class="checkbox">
    <label for="is_default" class="control-label">
        <input type="checkbox"
               name="is_default"
               id="is_default"
                {{ $item->is_default ? "checked" : ""}}
        />{{ trans('newsletter::fields.is_default') }}

    </label>
</div>
@if (isset($item->id) && $item->emails->count())
    <div>
        <a href="/admin/newsletter/lists/export/{{ $item->id }}" target="_blank" class="btn btn-primary"
           role="button">Export emails in this list</a>
    </div>
@endif