<?php

/**
 * Newsletter Controller
 *
 * @category Mtc\Components\Newsletter\Http\Controllers
 * @package  Mtc\Components\Newsletter\Http\
 * @author   Justyna Cala <justyna.cala@mtcmedia.co.uk>
 * @version 2017.06.13
 */

namespace Mtc\Components\Newsletter\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\View\View;
use Mtc\Components\Newsletter\NewsletterList;
use Mtc\Components\Newsletter\NewsletterEmail;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Class NewsletterController
 *
 * @package Mtc\Components\Newsletter\Http\Controllers
 */
class NewsletterController extends Controller
{

    /**
     * Sign up a user to the newsletter
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function signUp(Request $request)
    {

        $this->validate($request, [
            'newsletter_email' => 'email|required',
        ]);

        $list = NewsletterList::where('is_default', 1)->first();

        if (!isset($list->id) || empty($list->id)) {
            $list = new NewsletterList;
            $list->name = 'Newsletter Signup';
            $list->is_default = 1;
            $list->save();
        }

        //check whether we have this emailed sighed up
        $exists = $this->checkIfSignedUp($request->input('newsletter_email'), $list);

        //if not create an entry
        if (empty($exists)) {
            NewsletterEmail::create([
                'email' => $request->input('newsletter_email'),
                'list_id' => $list->id
            ]);
        }

        session([
            'newsletter.signed_up' => '1'
        ]);

        return response()->json([
            'result' => 'success'
        ]);
    }

    /**
     * Check whether the email has been signed up
     *
     * @param string $email
     * @param NewsletterList $list
     *
     * @return bool
     */
    public function checkIfSignedUp($email, NewsletterList $list)
    {
        return NewsletterEmail::where('email', $email)
                ->where('list_id', $list->id)
                ->count() > 0;
    }

    /**
     * Check whether there is a signed up session set
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function checkIfSignedUpSession(Request $request)
    {
        return response()->json($request->session()->has('newsletter.signed_up'));
    }

    /**
     * Sign up a user to the newsletter
     *
     * @return \Illuminate\View\View
     */
    public function showSignUpForm()
    {
        return view('newsletter::subscribe_page', [
            'subscribe_action' => route('newsletter.sign_up'),
            'subscribed_action' => route('newsletter.signed_up'),
        ]);
    }
}
