<?php

/**
 * NewsletterEmail Model
 *
 * PHP Version 7
 *
 * @category Mtc\Components\Newsletter\Model
 * @package  Mtc\Components\Newsletter
 * @author   Justyna Cala <justyna.cala@mtcmesia.co.uk>
 */

namespace Mtc\Components\Newsletter;

use Illuminate\Database\Eloquent\Model;

/**
 * Class NewsletterEmail
 *
 * NewsletterEmail eloquent class.
 *
 * @package Mtc\Components\Newsletter
 * @author Justyna Cala <justyna.cala@mtcmedia.co.uk>
 * @version 2017-06-20
 */
class NewsletterEmail extends Model
{
    /**
     * Attributes which can be mass-assigned
     *
     * @var array
     */
    protected $fillable = [
        'email',
        'list_id',
    ];

    /**
     * The table associated with the model
     * @var string
     */
    protected $table = "newsletter_list_emails";

    /**
     * Get the collection of list this email belongs to
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function lists()
    {
        return $this->belongsToMany(NewsletterList::class);

    }

}