<?php

/**
 * NewsletterList Model
 *
 * @category Mtc\Components\Newsletter\Model
 * @package  Mtc\Components\Newsletter
 * @author   Justyna Cala <justyna.cala@mtcmesia.co.uk>
 */

namespace Mtc\Components\Newsletter;

use Illuminate\Database\Eloquent\Model;

/**
 * Class NewsletterList
 *
 * NewsletterList eloquent class.
 *
 * @package Mtc\Components\Newsletter
 * @author Justyna Cala <justyna.cala@mtcmedia.co.uk>
 * @version 2017-06-20
 */
class NewsletterList extends Model
{
    /**
     * Attributes which can be mass-assigned
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'is_default'
    ];

    /**
     * The table associated with the model
     * @var string
     */
    protected $table = "newsletter_lists";

    /**
     * Get the list of emails belonging to this list
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function emails()
    {
        return $this->hasMany(NewsletterEmail::class, 'list_id');
    }
}
