<?php
/**
 * NewsletterEventServiceProvider class
 *
 * @category Mtc\Components\Newsletter\Providers
 * @package  Mtc\Components\Newsletter
 * @author Justyna Cala <justyna.cala@mtcmedia.co.uk>
 */

namespace Mtc\Components\Newsletter\Providers;


use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Components\Newsletter\Listeners\LoadNewsletterForm;
use Mtc\Components\Newsletter\Listeners\LoadTab;
use Mtc\Core\Admin\Menu;
use Mtc\Core\Events\Admin\MenuLoading;

/**
 * Class NewsletterEventServiceProvider
 *
 * @package Mtc\Components\Newsletter
 */
class NewsletterEventServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider. Add event listeners if component is enabled.
     *
     * @return void
     */
    public function boot()
    {
        if ( config('newsletter.enabled') ) {

            // When the event fires
            Event::listen(
                MenuLoading::class, function () {
                Menu::addSection('Newsletter', 'newsletter');
                Menu::addMenu('newsletter', 'Newsletter', '', 'newsletter_lists', 'glyphicon glyphicon-user');
                Menu::addSubMenu(
                    // Menu key
                    'newsletter_lists',
                    // Title
                    'Manage Newsletter Lists',
                    // Permission key
                    '',
                    // URL to be shown
                    route('newsletter.admin.lists.index'),
                    // Unique key for this sub-menu
                    'manage_newsletter_lists'
                );
            });
        }

        Event::listen('core.footer', LoadNewsletterForm::class);
    }
}