<?php
/**
 * Newsletter Service Provider
 *
 * @category Mtc\Components\Newsletter\Providers
 * @package  Mtc\Components\Newsletter
 * @author   Justyna Cala <justyna.cala@mtcmedia.co.uk>
 */

namespace Mtc\Components\Newsletter\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Routing\Router;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Components\Newsletter\NewsletterList;
use Route;

/**
 * Class NewsletterServiceProvider
 *
 * @package Mtc\Components\Newsletter
 */
class NewsletterServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider and load config.
     *
     * @return bool
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/newsletter.php', 'newsletter'
        );

    }

    /**
     * Boot the service provider if component is enabled.
     *
     * @return void
     */
    public function boot()
    {
        if (config('newsletter.enabled')) {
            $this->defineResources();
            $this->defineRoutes();
        }

    }


    /**
     * function defineResources
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'newsletter');
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'newsletter');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * function defineRoutes
     *
     * @return void
     */
    protected function defineRoutes()
    {
        // define mapping for {newsletter_list} to a Newsletter List instance
        Route::model('newsletter_list', NewsletterList::class);

        // Set up routes used by the component
        if (!$this->app->routesAreCached()) {
            Route ::group([
                'namespace' => '\Mtc\Components\Newsletter\Http\Controllers',
                'middleware' => ['web'],
                'as' => 'newsletter.'
            ], function (Router $router) {

                $router->get('newsletter/subscribe', 'NewsletterController@showSignUpForm');
                $router->post('newsletter/subscribe', 'NewsletterController@signUp')->name('sign_up');
                $router->get('newsletter/signed-up', 'NewsletterController@checkIfSignedUpSession')->name('signed_up');

                // Admin routes
                $router->group([
                    'prefix'     => 'admin/newsletter',
                    'middleware' => ['auth', 'permission:admin'],
                    'as'         => 'admin.',
                ], function (Router $router) {
                    $router->resource('lists', 'Admin\NewsletterController');
                    $router->get('lists/export/{newsletter_list}', 'Admin\NewsletterController@exportAndDie');
                });
            });
        }
    }
}