<?php
/**
 * Artisan command for creating a PayPal certificate
 *
 * PHP Version 7
 *
 * @category Mtc\Components\Paypal\Console\Commands
 * @package  Mtc\Components\Paypal
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Components\Paypal\Console\Commands;

use Illuminate\Console\Command;

/**
 * Artisan command for creating a PayPal certificate
 *
 * Usage: php artisan create:paypal_cert
 * After inputting default certificate settings certificate files will be created
 * in /resources/certificates
 * Certificate must be generated for every live paypal gateway integration.
 * Further instructions on https://developer.paypal.com/webapps/developer/docs/classic/paypal-payments-standard/integration-guide/encryptedwebpayments/#id08A3I0Q0CQN
 *
 * @category Mtc\Components\Paypal\Console\Commands
 * @package  Mtc\Components\Paypal
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class MakePaypalCertificate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:paypal_cert';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates paypal certificate';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command for generating a new certificate.
     *
     * @return mixed
     */
    public function handle()
    {
        chdir(resource_path('certificates'));
        exec("/usr/bin/openssl genrsa -out ours_paypal.key 1024");
        exec("/usr/bin/openssl req -new -key ours.key -x509 -days 1825 -out ours_paypal.crt");
    }
}
