<?php
/**
 *
 * PhoneOrder
 *
 * PHP Version 7
 *
 * @category Mtc\Components\PhoneOrder
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 21/03/2017 11:43
 *
 */

namespace Mtc\Components\PhoneOrder;


use Illuminate\Support\Facades\Auth;
use Mtc\Shop\Abstracts\PaymentGateway;
use Mtc\Shop\Order\Order;

/**
 * Class PhoneOrder Payment gateway
 *
 * @package Mtc\Components\PhoneOrder
 */
class PhoneOrder extends PaymentGateway
{
    /**
     * Set if the place order button should be renamed on selection.
     *
     * @var string
     */
    public $order_button_text;

    /**
     * True/false based on whether the method is enabled.
     *
     * @var bool
     */
    public $enabled;

    /**
     * Payment method title for the frontend.
     *
     * @var string
     */
    public $title;

    /**
     * Payment method description for the frontend.
     *
     * @var string
     */
    public $description;

    /**
     * True if the gateway shows fields on the checkout.
     *
     * @var bool
     */
    public $has_fields = true;

    /**
     * Icon for the gateway.
     *
     * @var string
     */
    public $icon;

    /**
     * get user editable properties from config...
     *
     * @return void
     */
    public function __construct()
    {
        $this->enabled           = config('phone-order.enabled');
        $this->description       = config('phone-order.description');
        $this->order_button_text = config('phone-order.order_button_text');
        $this->title             = config('phone-order.title');

        parent::__construct();
    }

    /**
     * Get the url which contains the payment form.
     *
     * @param Order $order The order object.
     *
     * @return string        Transaction URL, or empty string.
     */
    public function getTransactionUrl($order)
    {
        return route('phone-order.create');
    }

    /**
     * Get the url to send the payment request to.
     *
     * @param Order $order Incoming Order
     *
     * @return string URL to redirect to
     */
    public function getReturnUrl($order = null)
    {
        return route('phone-order.store');
    }

    /**
     * function isAvailable
     *
     * Phone orders can be used if the user is logged in, has the right permission, and the component is enabled
     *
     * @return bool
     */
    public function isAvailable()
    {

        return ((!is_null(Auth::user())
                 && Auth::user()->can('create-phone-orders'))
                 && $this->enabled);
    }
}