<?php
/**
 *
 * PhoneOrderServiceProvider
 *
 * PHP Version 7
 *
 * @category Mtc\Components\PhoneOrder\Providers
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 21/03/2017 13:45
 *
 */

namespace Mtc\Components\PhoneOrder\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\Components\PhoneOrder\Http\Controllers\PhoneOrderController;
use Mtc\Components\PhoneOrder\PhoneOrder;
use Mtc\Shop\Events\RetrievePaymentGateways;


/**
 * Class PhoneOrderServiceProvider
 *
 * @package Mtc\Components\PhoneOrder
 */
class PhoneOrderServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineEvents();
        $this->defineRoutes();
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/phone-order.php', 'phone-order'
        );
    }

    /**
     * Define resources for this package
     *
     * @return void
     */
    private function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'phone-orders');
        $this->publishes([
            __DIR__ . '/../../database/seeds/' => database_path('seeds'),
        ], 'seeds');
    }

    /**
     * Listen for events needed by this package
     *
     * @return void
     */
    private function defineEvents()
    {
        if (config('phone-order.enabled')) {
            Event::listen(RetrievePaymentGateways::class, function () {
                return new PhoneOrder;
            });
        }
    }

    /**
     * Define routes for this package
     *
     * @return void
     */
    private function defineRoutes()
    {
        if (! $this->app->routesAreCached()) {
            Route::group(
                ['middleware' => 'web'], function ($router) {
                    $router->get('payment/phone-order', PhoneOrderController::class . '@create')
                        ->name('phone-order.create');

                    $router->post('payment/phone-order/process', PhoneOrderController::class . '@store')
                        ->name('phone-order.store');
                }
            );
        };
    }
}
