# Phone Orders Component #

Adds a new payment method to the store, so that site administrators can
record telephone payment orders.

# Installation #

```composer require mtc/phone-order```

```php artisan db:seed --class=PhoneOrdersPermissionSeeder```

# Usage #
You now have a new permission **create-phone-orders**. Any user who has
this permission can now use the Phone Orders payment gateway to create
new orders through the main shop interface.

All the gateway does is take a transaction ID (which the user must
obtain from their virtual terminal when taking payments over the phone),
and records a new paid order. It does not do any validation on the
transaction ID.
 
# Configuration #
Elements of the component that can be modified are in /config/phone-order.php
under the component's installation directory. You may modify the following:

 - `enabled (true|false)`: turns the component on or off
 - `description`: displayed above the payment form
 - `order_button_text`: the submit button value
 - `title`: the name of the payment method displayed on the gateway
  selection in basket overview and also stored in the database as
  payment_type and in the order's notes.