<?php

use Illuminate\Database\Seeder;
use Mtc\Core\Auth\Permission;

/**
 * Class PhoneOrdersPermissionSeeder
 *
 * @package Mtc\Components\PhoneOrder\Seeds
 * @author  Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 */
class PhoneOrdersPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * Add a permissions record for phone orders. Enables users to register telephone orders through the main shop interface
     *
     * @return void
     */
    public function run()
    {
        if (Permission::where('name', 'create-phone-orders')->count() == 0) {
            $permission = new Permission;

            $permission->name       = 'create-phone-orders';
            $permission->guard_name = 'web';

            $permission->save();
        }
    }
}
