<?php
/**
 * Form Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Components\SagepayForm\Providers
 * @package  Mtc\Components\SagepayForm
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Components\SagepayForm\Providers;

use Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Components\SagepayForm\Http\Controllers\SagepayFormController;
use Mtc\Components\SagepayForm\SagepayForm;
use Mtc\Shop\Events\RetrievePaymentGateways;
use Route;

/**
 * Connect the Sagepay Payment Provider to Laravel
 *
 * @category Mtc\Components\SagepayForm\Providers
 * @package  Mtc\Components\SagepayForm
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class SagepayFormServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineEvents();
        $this->defineRoutes();
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {

        $this->mergeConfigFrom(
            __DIR__ . '/../../config/sagepay-form.php', 'sagepay-form'
        );
    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'sagepay-form');

        $this->publishes(
            [
            __DIR__.'/../../config/sagepay-form.php' => config_path('sagepay-form.php'),
            ]
        );
    }

    /**
     * Load any events required for this package.
     *
     * This listens to see if the 'RetrievePaymentGateways' event is triggered
     * and returns a new copy of the form if so.
     *
     * @return void
     */
    protected function defineEvents()
    {
        Event::listen(
            RetrievePaymentGateways::class, function () {
                return new SagepayForm;
            }
        );
    }

    /**
     * Load routes to send the form and to process the incoming request.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        if (! $this->app->routesAreCached()) {

            Route::group(
                ['middleware' => 'web'], function ($router) {
                    $router->get('payment/sagepay-form', SagepayFormController::class . '@index')
                        ->name('sagepay-form.index');

                    $router->get('payment/sagepay-form/process', SagepayFormController::class . '@process')
                        ->name('sagepay-form.process');
                }
            );

        };
    }
}
