<?php
/*
 * Media file configuration structure
 * Each media entity must be an array that has the key of the media linked item class
 * Each media entity must have a default key 'upload_path' that represents where original images will be uploaded
 * Each media image size is an array that has the path, width and height attached
 * If height is not attached the image will be cropped square
 */
return [
    \Mtc\Shop\Product::class => [
        'upload_path' => 'products/original',
        [
            'path' => 'products/large',
            'width' => 767,
            'height' => 767
        ],
        [
            'path' => 'products/square',
            'width' => 500
        ],
        [
            'path' => 'products/small',
            'width' => 326,
            'height' => 326
        ]
    ]
];