<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;

class OrderStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (DB::table('order_statuses')->count() > 0) {
            return;
        }

        $data = collect([
            [
                'title' => 'Received',
                'is_email_sent' => true,
            ],
            [
                'title' => 'Payment Accepted',
                'is_email_sent' => false,
            ],
            [
                'title' => 'Payment Rejected',
                'is_email_sent' => false,
            ],
            [
                'title' => 'On Picking',
                'is_email_sent' => false,
            ],
            [
                'title' => 'Shipped',
                'is_email_sent' => true,
            ],
            [
                'title' => 'Part Shipped',
                'is_email_sent' => false,
            ],
            [
                'title' => 'Part Refunded',
                'is_email_sent' => false,
            ],
            [
                'title' => 'Refunded',
                'is_email_sent' => true,
            ],
            [
                'title' => 'Waiting for response',
                'is_email_sent' => false,
            ],
            [
                'title' => 'Cancelled',
                'is_email_sent' => false,
            ],
        ])->map(function($item) {
            $item['created_at'] = (new Carbon)->toDateTimeString();
            return $item;
        })->toArray();

        DB::table('order_statuses')->insert($data);
    }
}
