@extends('theme::layouts.public')

@section('content')

    <div id="checkout">

        <basket basket-in="{{ $basket }}"
            inline-template
            v-cloak>
            <div>

                <h2>{{ trans('shop::basket.overview.title') }}</h2>

                <div class="orderSummaryWrap">
                    @include('shop::public.partials.basket.view')
                    <a class="goBack"
                        href="{{ route('shop.basket.index') }}">
                            {{ trans('shop::basket.overview.back') }}
                    </a>
                </div><!-- .orderSummaryWrap -->

                <div class="userDetailsWrap">
                    <h2>{{ trans('shop::basket.overview.details_title') }}</h2>
                    @include('shop::public.partials.basket.details_overview')

                    <p>All transactions are secured and encrypted. Credit card information is never stored.</p>

                    <form action="{{ route('shop.basket.overview.confirm') }}" method="post">
                        {{ csrf_field() }}

                        <ul id="payment_methods">
                        @foreach ($payment_gateways as $index => $method)
                            @if($method->isAvailable())
                                <li class="row">
                                    <input type="radio"
                                        name="payment_method"
                                        id="payment_method_{{ $index }}"
                                        value="{{ get_class($method) }}"
                                        {{ old('payment_method', get_class(reset($payment_gateways))) == get_class($method) ? 'checked' : '' }}
                                        >
                                    <label for="payment_method_{{ $index }}">
                                        {{ $method->title }}
                                    </label>
                                </li>
                            @endif
                        @endforeach
                        </ul>

                        <button type="submit" class="button">
                            Pay Securely
                        </button>

                    </form>


                    {{-- <form action="{{ route('shop.basket.overview.confirm') }}" method="post">
                        {{ csrf_field() }}
                        <button type="submit">
                            Mark Paid
                        </button>
                    </form> --}}
                </div><!-- .userDetailsWrap -->

            </div>
        </basket>

    </div>

@endsection
