<?php
/**
 * Checkout View Composer
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\ViewComposers;

use Illuminate\View\View;

/**
 * Display any data required for checkout to a view.
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CheckoutComposer
{
    /**
     * Plug additional external scripts to checkout process.
     * e.g. stripe has a JS that needs to be added
     *
     * @param View $view Source View
     *
     * @return void
     */
    public function compose(View $view)
    {
        // Find external scripts that should be passed into this template
        // We are also flattening the event responses as each event could pass multiple scripts
        $external_scripts = collect(event('shop.external_checkout_scripts'))
            ->flatten()
            ->reject(function ($script) {
                // If the event returned an empty response we should ignore it
                return empty($script);
            });

        // Only add the additional variable if we have scripts in it
        if ($external_scripts->count() > 0) {
            $view->with([
                'external_checkout_scripts' => $external_scripts
            ]);
        }
    }
}
