<?php
/**
 *
 * IncrementNumSold
 *
 * PHP Version <7>
 *
 * @category Mtc\Shop\Listeners
 * @author   Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 *
 * Created: 18.06.2017
 *
 */

namespace Mtc\Shop\Listeners;

use Mtc\Shop\Events\OrderPaid;
use Mtc\Shop\Product;


/**
 * Class IncrementNumSold
 *
 * @package Mtc\Shop\Listeners
 */
class IncrementNumSold
{
    /**
     * Handle the OrderPaid event by incrementing the number of products sold
     *
     * @param OrderPaid $event
     *
     * @return void
     */
    public function handle(OrderPaid $event)
    {
        $order = $event->order;

        // increment number of sold items for each product in order
        foreach ($order->items as $order_item) {
            Product::find($order_item->product_id)
                ->increment('num_sold', $order_item->quantity);
        }

    }
}