<div class="form-group">
    <label for="variant_sku">{{ trans('fields.variants.sku') }}</label>
    <input type="text"
        name="variant[sku]"
        id="variant_sku"
        class="form-control"
        placeholder="{{ trans('fields.variants.sku') }}"
        value="{{ Request::old('variant.sku', $item->sku) }}"
        />
    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.sku'])
</div>

<h3>Stock</h3>

<div class="checkbox">
    <label>
        <input type="hidden" name="variant[stock_enabled]" value="0">
        <input type="checkbox"
            name="variant[stock_enabled]"
            value="1"
            aria-describedby="variant_stock_enabled_help"
            @if (Request::old('variant.stock_enabled', $item->stock_enabled) == 1)
                checked
            @endif
            > Manage Stock?
    </label>

    <span id="variant_stock_enabled_help" class="help-block">
        Enable stock management at a variant level
    </span>
</div>

<div class="form-group">
    <label for="variant_stock_quantity">{{ trans('fields.variants.stock_quantity') }}</label>
    <input type="number"
        step="1"
        name="variant[stock_quantity]"
        id="variant_stock_quantity"
        class="form-control"
        placeholder="{{ trans('fields.variants.stock_quantity') }}"
        value="{{ Request::old('variant.stock_quantity', $item->stock_quantity) }}"
        />
    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.stock_quantity'])
</div>

<h3>Shipping</h3>


<div class="form-group">
    <label for="variant_shipping_weight">{{ trans('fields.variants.shipping_weight') }}</label>
    <input type="number"
        step="0.05"
        name="variant[shipping_weight]"
        id="variant_shipping_weight"
        class="form-control"
        placeholder="{{ trans('fields.variants.shipping_weight') }}"
        value="{{ Request::old('variant.shipping_weight', $item->shipping_weight) }}"
        />
    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.shipping_weight'])
</div>

<div class="form-group">
    <label for="variant_shipping_dimensions">{{ trans('fields.variants.shipping_dimensions') }}</label>
    <div class="row">
        <div class="col-md-4">
            <input type="number"
                step="0.05"
                name="variant[shipping_dimensions_length]"
                id="variant_shipping_dimensions_length"
                class="form-control"
                placeholder="{{ trans('fields.variants.shipping_dimensions_length') }}"
                value="{{ Request::old('variant.shipping_dimensions_length', $item->shipping_dimensions_length) }}"
                />
        </div>
        <div class="col-md-4">
            <input type="number"
                step="0.05"
                name="variant[shipping_dimensions_width]"
                id="variant_shipping_dimensions_width"
                class="form-control"
                placeholder="{{ trans('fields.variants.shipping_dimensions_width') }}"
                value="{{ Request::old('variant.shipping_dimensions_width', $item->shipping_dimensions_width) }}"
                />
        </div>
        <div class="col-md-4">
            <input type="number"
                step="0.05"
                name="variant[shipping_dimensions_height]"
                id="variant_shipping_dimensions_height"
                class="form-control"
                placeholder="{{ trans('fields.variants.shipping_dimensions_height') }}"
                value="{{ Request::old('variant.shipping_dimensions_height', $item->shipping_dimensions_height) }}"
                />
        </div>
    </div>

    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.shipping_dimensions_length'])
    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.shipping_dimensions_width'])
    @include('core::layouts.partials.admin.field_error', ['field' => 'variant.shipping_dimensions_height'])

</div>
