@if ($variants->isEmpty() == false)
    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Title</th>
                <th>SKU</th>
                <th>Stock Quantity</th>
                <th></th>
            </tr>
        </thead>

        <tbody>
        @foreach ($variants as $variant)
            <tr>
                <td>{{ $variant->id }}</td>
                <td>
                    <a href="{{ route('shop.admin.variants.edit', [$variant->product, $variant]) }}">
                        {{ $variant->node->title }}
                    </a>
                </td>
                <td>{{ $variant->sku }}</td>
                <td>{{ $variant->stock_enabled ? $variant->stock_quantity : 'N/A' }}</td>
                <td class="text-right block">
                    <div class="btn-group">
                        <a href="{{ route('shop.admin.variants.edit', [$variant->product->id, $variant->id]) }}"
                           class="btn btn-primary">
                           Edit
                        </a>
                        <delete action="{{ route('shop.admin.variants.destroy', [$variant->product->id, $variant->id]) }}"></delete>
                    </div>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endif

{!! $variants->render() !!}
