<?php
/**
 * Product Media Controller (Admin)
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Controllers\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use Mtc\Core\Admin\ItemBuilder;
use Mtc\Core\Media;
use Mtc\Shop\Http\Requests\StoreImage;
use Mtc\Shop\Product;

/**
 * Actions concerning display and upload of media for a product
 *
 * @category Mtc\Shop\Http\Controllers\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class MediaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Product $product Product Model
     *
     * @return \Illuminate\View\View
     */
    public function index(Product $product)
    {
        return (new ItemBuilder('shop.admin.product', $product, $product->node))
            ->tab(
                'shop::admin.media.index', [
                'media' => $product->media->map(
                    function($media) {
                        $media->href = asset('storage/' . $media->src);
                        return $media;
                    }
                )
                ]
            );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreImage $request Validated Request
     * @param Product    $product Product to attach media to
     *
     * @return \Illuminate\Http\Response
     */
    public function store(StoreImage $request, Product $product)
    {
        $path = $request->file('file')->store('products', 'public');

        $media = new Media(
            [
            'src' => $path,
            'title' => $request->file('file')->getClientOriginalName(),
            'type' => $request->file('file')->getMimeType(),
            ]
        );

        $product->media()->save($media);
        return $product->media->map(
            function($media) {
                $media->href = asset('storage/' . $media->src);
                return $media;
            }
        );
    }

    /**
     * Remove the specified resource from storage.
     *
     * @todo
     * @param int $id Media ID
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
