<?php
/**
 * Product Controller (Public)
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Controllers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Shop\Product;

/**
 * Control this display of products on the public site.
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Controllers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ProductController extends Controller
{
    /**
     * Show the product.
     *
     * @param int $id Product ID
     *
     * @return \Illuminate\View\View
     */
    public function show($id)
    {
        $product = Product::with(
            [
                'media',
                'variants',
                'variants.node'
            ]
        )->find($id);

        return view('shop::public.product')->with(compact('product'));
    }
}
