<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVariantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('variants', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('product_id')->unsigned();

            $table->string('code')->nullable()->index();

            $table->boolean('stock_enabled')->index();
            $table->integer('stock_quantity')->index()->default(0);

            $table->decimal('shipping_weight', 15, 5)->nullable();
            $table->decimal('shipping_dimensions_length', 15, 5)->nullable();
            $table->decimal('shipping_dimensions_width', 15, 5)->nullable();
            $table->decimal('shipping_dimensions_height', 15, 5)->nullable();

            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('products')
                ->onUpdate('cascade')->onDelete('cascade');
        });

        Schema::create('price_per_variants', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('variant_id')->unsigned();
            $table->decimal('price', 10,2)->unsigned();
            $table->integer('quantity')->unsigned()->index();
            $table->timestamps();

            $table->unique(['variant_id', 'quantity']);
            $table->foreign('variant_id')
                ->references('id')
                ->on('variants')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('price_per_variants');
        Schema::dropIfExists('variants');
    }
}
