<div class="row">
    <input type="text" placeholder="Search" v-model="options.query">

    @if (env('SCOUT_DRIVER', 'algolia') == 'algolia')
        <span class="pull-right" style="opacity: 0.6;">Powered by <img src="/images/algolia.jpg" alt="Powered by Algolia" style="height:15px;" /></span>
    @endif
</div>

<h2 class="refineSelection">
    Refine Selection&nbsp;<i class="fa fa-plus"></i>
</h2>

<div class="productFilterSelectionWrap">
    <div class="productFilterSelection">
        <div class="selectionsWrap">
            <div id="productFilterSelections">
                <div class="currentSelectionWrap" v-show="options.selected.length > 0">
                    <h3 class="collapseMe">Current Selection<i class="icon-arrow"></i></h3>


                    <div class="currentSelection">
                        <div class="overflowWrap">
                            <a class="filterLink"
                               @click="options.selected = []"
                               v-show="options.selected.length > 1">
                                <i class="fa fa-refresh"></i>Clear All
                            </a>

                            <div v-for="(option, index) in options.selected">
                                <a class="flink" rel="nofollow" @click="removeSelected(index)"><i class="fa fa-times"></i>@{{ option.title }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- .selectionsWrap -->

        <div class="filterSortBoxWrap" v-for="taxonomy in taxonomies" v-if="taxonomy.children.length > 0">
            <h3 class="collapseMe">
                @{{ taxonomy.title }}&nbsp;<i class="fa fa-angle-up"></i>
            </h3>

            <div class="overflowWrap">
                <div class="checkboxRow" v-for="child in taxonomy.children">
                    <input class="ftick"
                           :id="'f_cat_' + child.id + '_chk'"
                           type="checkbox"
                           :checked="isSelected(child)"
                           @click="toggle(child)">
                        <label :for="'f_cat_' + child.id + '_chk'">
                            <span>
                                <a :href="child.url"
                                   class="flink"
                                   rel="nofollow"
                                   >@{{ child.title }}</a>
                            </span>
                        </label>
                </div>
            </div>
        </div>

    </div> <!-- .productFilterSelection -->
</div> <!-- .productFilterSelectionWrap -->
