<div class="productFilterControls">
    <div class="filterTrigger">
        <h2>
            <a href="#">
                <span>Refine Selection</span>
                <i class="fa fa-bars"></i>
            </a>
        </h2>
    </div>
    <div id="productFilterSort">
        <select class="orderby fdropdown" v-model="options.sort_by">
            <option v-for="option in sortOptions"
                    :value="option.key"
                    >@{{ option.label }}
            </option>
        </select>
    </div>
    <div id="productFilterPageNumbers">
        <div class="centerPush">
            <div class="centerPull">
                <ul class="pagination">
                    <li class="first-item">
                        <span class="paginationnumbers">
                            Page @{{ products.current_page }} of @{{ products.last_page }}
                        </span>
                    </li>

                    <li v-if="products.current_page > 1">
                        <a @click="changePage(options.page - 1)"
                           rel="prev">
                           Previous
                        </a>
                    </li>

                    <li v-for="count in pagination" v-if="products.last_page > 1">

                        <span v-if="count == products.current_page">@{{ count }}</span>

                        <a v-else
                           @click="changePage(count)"
                           :class="{flink: count > products.current_page, plink: count < products.current_page, active: count == products.current_page}"
                           >
                            @{{ count }}
                        </a>
                    </li>

                    <li v-if="products.current_page < products.last_page">
                        <a @click="changePage(options.page + 1)"
                           rel="next">
                           Next
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="numberOfProducts">
            @{{ products.total }} Product@{{ products.total != 1 ? 's' : '' }}
        </div>
    </div>
</div>

<div id="productFilterItems">
    <ul class="itemsBrowse">
        <li v-for="product in products.data">
            <a :href="product.url">
                <div class="itemImageWrap">
                    <img v-if="{{ env('BROWSE_IMAGES', true) ? 'true' : 'false' }} && product.nodeable.media.length > 0 && product.nodeable.media[0].src.length > 0"
                         :src="'{{ asset('storage', false) }}/' + product.nodeable.media[0].src"
                         :alt="product.title + ' product image'">
                    <img v-else
                         src="/images/default.png"
                         alt="">
                </div> <!-- .itemImageWrap -->

                <h3>@{{ product.title }}</h3>
                <div class="itemPriceWrap">
                    <span class="priceStandard">
                        <span class="multiprice">
                            <span class="GBP show">@{{ product.price | currency }}</span>
                        </span>
                    </span>
                </div>
            </a>
        </li>
    </ul>
</div>
