@extends('theme::layouts.public')

@section('head')
    <link rel="canonical" id="canonical" href="{{ $json['url'] }}" />
@endsection

@section('content')

    <browse inline-template v-cloak selected="{{ $selected }}" page="{{ $page }}" sort="{{ $sort }}">
        <div>
            <div id="browse" role="main">
                <div id="productFilterTitle" class="categoryHeader"></div>
                <div id="productFilterBreadcrumbs"></div>


                <div id="productFilter">
                    @include('shop::public.partials.filter')
                </div> <!-- #productFilter -->

                <div class="filterContent">
                    @include('shop::public.partials.filter_title')
                    @include('shop::public.partials.filter_content')
                </div> <!-- .filterContent -->
            </div> <!-- #browse -->
        </div>
    </browse>

@endsection

@push('pre_scripts')
    <script type="application/json" id="browseData">{!! json_encode($json) !!}</script>
@endpush
