<fieldset class="personalDetails">

    {{-- First Name --}}
    <div class="row {{ $errors->has('first_name') ? 'errorWrap showError' : '' }}">
        <label for="personalFirstName" class="required">
            {{ trans('shop::basket.personal.first_name') }}
        </label>

        <input id="personalFirstName"
            name="first_name"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('first_name', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('first_name')])
    </div>

    {{-- Last Name --}}
    <div class="row {{ $errors->has('last_name') ? 'errorWrap showError' : '' }}">
        <label for="personalLastName" class="required">
            {{ trans('shop::basket.personal.last_name') }}
        </label>

        <input id="personalLastName"
            name="last_name"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('last_name', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('last_name')])
    </div>

    {{-- Email Address --}}
    <div class="row {{ $errors->has('email') ? 'errorWrap showError' : '' }}">
        <label for="personalEmail" class="required">
            {{ trans('shop::basket.personal.email') }}
        </label>

        <input id="personalEmail"
            type="email"
            name="email"
            maxlength="75"
            aria-required="true"
            class="text"
            value="{{ old('email', $basket->email) }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('email')])
    </div>

    {{-- Phone Number --}}
    <div class="row {{ $errors->has('phone') ? 'errorWrap showError' : '' }}">
        <label for="personalPhoneNumber" class="required">
            {{ trans('shop::basket.personal.phone_number') }}
        </label>

        <input id="personalPhoneNumber"
            type="tel"
            name="phone"
            maxlength="50"
            aria-required="true"
            class="text"
            value="{{ old('email', $basket->phone) }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('phone')])
    </div>
</fieldset>
