<?php
/**
 * Price Method Contract
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Contracts;

use Mtc\Shop\Product;
use Mtc\Shop\Variant;

/**
 * This interface defines the necessary methods for building a Price Method
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
interface PriceMethod
{

    /**
     * Setup the price method
     *
     * @param Mtc\Shop\Product      $product Product Model
     * @param Mtc\Shop\Variant|null $variant Variant Model (if required)
     *
     * @return void
     */
    public function __construct(Product $product, Variant $variant = null);

    /**
     * Get the current price for a single item
     *
     * @param integer $quantity (default: 1)
     *
     * @return integer
     */
    public function single();

    /**
     * Get the min/max price for an product.
     *
     * @param integer $quantity (default: 1)
     *
     * @return float[]
     */
    public function range(int $quantity = 1);

    /**
     * Get the price for an item if the user requests the provided quantity
     *
     * @param integer $quantity (default: 1)
     *
     * @return integer
     */
    public function multiple(int $quantity = 1);
}
