<div class="bagItem">
    <div class="bagThumb"></div>

    <div class="bagDescription">
        <a :href="line.url" class="bagTitle">
            @{{ line.variant.product.node.title }}
        </a>
    </div><!-- .bagDescription -->

    <div class="bagSize">@{{ line.variant.node.title }}</div>

    <div class="bagUnitPrice">
        @{{ line.price_unit | currency }}
    </div>

    <div class="bagQuantity">

        <div v-if="basket.editable">
            <button @click.prevent="line.quantity-- && debounceUpdate()"
                :disabled="line.quantity < 2"
                title="{{ trans('basket.reduce_quantity') }}">
                -
            </button>

            <input class="bagItemQuantity"
                type="number"
                min="0"
                max="999"
                v-model="line.quantity"
                @change="update()">

            <button @click.prevent="line.quantity++ && debounceUpdate()">
                +
            </button>
        </div>
        <div v-else>
            @{{ line.quantity }}
        </div>
    </div>

    <div class="bagCost">
        <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
        <span v-else>@{{ line.price_total | currency }}</span>
    </div>

    <div class="bagButtons" v-if="basket.editable">
        <button @click.prevent="remove(line)"
            class="itemDeleteButton"
            title="{{ trans('basket.remove_item') }}">
            <i class="fa fa-trash-o"></i>
        </button>
    </div>

</div>
