<?php
/**
 * StoreBasketItems Request
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate that the array sent when adding items matches what we are expecting.
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreBasketItems extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'items' => 'required|array',
            'items.*.variant_id' => 'required|exists:variants,id',
            'items.*.quantity' => 'required|integer|min:0'
        ];

        return $rules;
    }
}
