<?php
/**
 * Price Per Product Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\PriceMethods\Models
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\PriceMethods\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * If the PricePerProduct price method is used, this is where the data
 * is stored for each variant and it's corresponding price.
 *
 * @category Mtc\Shop\PriceMethods\Models
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class PricePerProduct extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_id',
        'quantity',
        'price',
    ];
}
