<div class="checkbox">
    <label>
        <input type="hidden" name="item[stock_enabled]" value="0">
        <input type="checkbox"
            name="item[stock_enabled]"
            value="1"
            aria-describedby="item_stock_enabled_help"
            @if (Request::old('item.stock_enabled', $item->stock_enabled) == 1)
                checked
            @endif
            > Manage Stock?
    </label>

    <span id="item_stock_enabled_help" class="help-block">
        Enable stock management at a product level
    </span>
</div>

<div class="form-group">
    <label for="tax">
        {{ trans('fields.tax') }}
    </label>

    <select name="item[tax]" id="tax" class="form-control">
        <option value="">Zero</option>
        @foreach (Config::get('tax.rates') as $key => $rates)
            <option value="{{ $key }}"
                @if (Request::old('item.tax', $item->tax) == $key)
                    selected
                @endif
            >{{ $key }}</option>
        @endforeach
    </select>
</div>

<div class="form-group">
    <label for="price_method">
        {{ trans('fields.price_method') }}
    </label>
    <select name="item[price_method]"
            id="price_method"
            class="form-control">
        @foreach ($price_methods as $method)
            <option value="{{ $method }}"
                {{ $method == $item->price_method ? 'selected' : '' }}
                >{{ class_basename($method) }}</option>
        @endforeach
    </select>
</div>
