<div class="checkoutSectionWrap">
    <h3 class="shipping">Billing Details</h3>

    {{-- Address (Line 1) --}}
    <div class="row {{ $errors->has('addresses.billing.address1') ? 'errorWrap showError' : '' }}">
        <label for="billingAddressLineOne" class="required">
            {{ trans('shop::basket.address.address1') }}
        </label>

        <input id="billingAddressLineOne"
            name="addresses[billing][address1]"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('address1', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.address1')])
    </div>

    {{-- Address (Line 2) --}}
    <div class="row {{ $errors->has('addresses.billing.address2') ? 'errorWrap showError' : '' }}">
        <label for="billingAddressLineTwo">
            {{ trans('shop::basket.address.address2') }}
        </label>

        <input id="billingAddressLineTwo"
            name="addresses[billing][address2]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('address2', 'billing') }}"
        >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.address2')])
    </div>

    {{-- City --}}
    <div class="row {{ $errors->has('addresses.billing.city') ? 'errorWrap showError' : '' }}">
        <label for="billingCity" class="required">
            {{ trans('shop::basket.address.city') }}
        </label>

        <input id="billingCity"
            name="addresses[billing][city]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('city', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.city')])
    </div>

    {{-- Postcode --}}
    <div class="row {{ $errors->has('addresses.billing.postcode') ? 'errorWrap showError' : '' }}">
        <label for="billingPostcode" class="required">
            {{ trans('shop::basket.address.postcode') }}
        </label>

        <input id="billingPostcode"
            name="addresses[billing][postcode]"
            type="text"
            maxlength="20"
            class="text"
            value="{{ $basket->getAddressValue('postcode', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.postcode')])
    </div>

    {{-- State --}}
    <div class="row {{ $errors->has('addresses.billing.state') ? 'errorWrap showError' : '' }}">
        <label for="billingState">
            {{ trans('shop::basket.address.state') }}
        </label>

        <input id="billingState"
            name="addresses[billing][state]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('state', 'billing') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.state')])
    </div>

    {{-- Country --}}
    <div class="row">
        <label for="billingCountry" class="required">
            {{ trans('shop::basket.address.country') }}
        </label>

        <select name="addresses[billing][country]">
            @foreach ($countries as $country)
                <option value="{{ $country->code }}"
                    {{ $country->code == $basket->getAddressValue('country', 'billing') ? 'checked' : '' }}
                    >{{ $country->name }}</option>
                    }
            @endforeach
        </select>
    </div>

</div>
