<?php
/**
 * Retrieve Payment Gateways Event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */


namespace Mtc\Shop\Events;

use Mtc\Shop\Contracts\OrderContract;

/**
 * Provide an event for components to register themselves as payment gateways
 * to be displayed during checkout.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class RetrievePaymentGateways
{
    /**
     * The order model.
     *
     * @var null|OrderContract
     */
    public $order = null;

    /**
     * Build the new event, adding in the order model.
     *
     * @param OrderContract $order Incoming Order
     *
     * @return void
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }
}
