<?php
/**
 * StoreProdut Request
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Requests\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Determine that data for a product is all valid before input.
 *
 * @category Mtc\Shop\Http\Requests\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreProduct extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'node.title' => 'required|max:255',
            'node.description' => 'required',
            'item.stock_enabled' => 'boolean',
            'item.price_method' => 'in:Mtc\Shop\PriceMethods\PerProduct,Mtc\Shop\PriceMethods\PerVariant',
            'price_per_product.quantity.0' => 'required_if:item.price_method,Mtc\Shop\PriceMethods\PerProduct|numeric|min:1',
            'price_per_product.price.0' => 'required_if:item.price_method,Mtc\Shop\PriceMethods\PerProduct',
            'price_per_product.price.*' => 'numeric|min:0',
            'price_per_product.quantity.*' => 'numeric|min:1'
        ];
    }
}
