<?php
/**
 * Shop Event Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\Events\Admin\RegisterCustomGroupModels;
use Mtc\Shop\Events\PriceUpdated;
use Mtc\Shop\Listeners\UpdateSortPrice;
use Mtc\Shop\Product;
use Mtc\Shop\Variant;

/**
 * Within this class are all the events which the Shop is listening and
 * reacting to.
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class EventServiceProvider extends ServiceProvider
{
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        Event::listen(
            RegisterCustomGroupModels::class,
            function ($event) {
                $event->group
                    ->registerModel(Product::class)
                    ->registerModel(Variant::class);
            }
        );

        Event::listen(
            'core.shop.price_methods',
            function () {
                return [
                'Mtc\Shop\PriceMethods\PerProduct',
                'Mtc\Shop\PriceMethods\PerVariant',
                ];
            }
        );

        Event::listen(PriceUpdated::class, UpdateSortPrice::class);

        Event::listen('Mtc\Core\Events\Admin\ItemLoading', 'Mtc\Shop\PriceMethods\Listeners\PerProductForm');
        Event::listen('Mtc\Core\Events\Admin\ItemLoading', 'Mtc\Shop\PriceMethods\Listeners\PerVariantForm');

        Event::listen('eloquent.saved: ' . Variant::class, 'Mtc\Shop\PriceMethods\Listeners\PerVariantSave');
        Event::listen('eloquent.deleted: ' . Variant::class, 'Mtc\Shop\PriceMethods\Listeners\PerVariantDelete');
        Event::listen('eloquent.deleted: ' . Variant::class, 'Mtc\Shop\Listeners\CreateDefaultVariant');
        Event::listen('eloquent.created: ' . Variant::class, 'Mtc\Shop\Listeners\DeleteDefaultVariant');

        Event::listen('eloquent.saved: ' . Product::class, 'Mtc\Shop\PriceMethods\Listeners\PerProductSave');
        Event::listen('eloquent.deleted: ' . Product::class, 'Mtc\Shop\PriceMethods\Listeners\PerProductDelete');
        Event::listen('eloquent.created: ' . Product::class, 'Mtc\Shop\Listeners\CreateDefaultVariant');
    }
}
