<?php
/**
 * Product Tests
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Tests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Mtc\Shop\PriceMethods\PerProduct;
use Mtc\Shop\Product;

/**
 * Ensure product pricing works as expected.
 *
 * @category Mtc\Shop\Tests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ProductTest extends TestCase
{
    use DatabaseTransactions;

    /**
     * Confirm that a default is set when created.
     *
     * @return void
     */
    public function testPriceMethodExists()
    {
        $product = new Product;
        $this->assertTrue($product->price instanceof PerProduct);
    }

    /**
     * Confirm that an exception is thrown is a price method doesn't exist
     * for a particular item.
     *
     * @return void
     */
    public function testPriceMethodWillThrowExceptionIfClassNotExists()
    {
        $product = new Product;
        $product->price_method = 'Fail';

        $this->expectException(\Exception::class);
        $product->price;
    }
}
