<div class="form-horizontal">

    <div class="form-group">
        <label for="title" class="col-sm-2 control-label">
            {{ trans('fields.title') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                class="form-control"
                name="title"
                id="title"
                placeholder="{{ trans('fields.title') }}"
                value="{{ Request::old('title', $item->title) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'title'])
        </div>
    </div>

    <div class="form-group">
        <label for="shipping_zone_id" class="col-sm-2 control-label">
            {{ trans('Zone') }}
        </label>
        <div class="col-sm-10">
            <select class="form-control"
                   name="shipping_zone_id"
                   id="shipping_zone_id">
                <option value="0">Choose Zone</option>
                @foreach ($shipping_zones as $zone)
                    <option value="{{ $zone->id }}"
                        {{ Request::old('shipping_zone_id', $item->shipping_zone_id) == $zone->id ? 'selected' : '' }}>
                        {{ $zone->title }}
                    </option>
                @endforeach
            </select>
            @include('core::layouts.partials.admin.field_error', ['field' => 'value'])
        </div>
    </div>

    <div class="form-group">
        <label for="value" class="col-sm-2 control-label">
            {{ trans('Value') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="value"
                   id="value"
                   placeholder="{{ trans('Value') }}"
                   value="{{ Request::old('value', $item->value) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'value'])
        </div>
    </div>

    <div class="form-group">
        <label for="min_basket_value" class="col-sm-2 control-label">
            {{ trans('Min Basket Value') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="min_basket_value"
                   id="min_basket_value"
                   placeholder="{{ trans('Min Basket Value') }}"
                   value="{{ Request::old('min_basket_value', $item->min_basket_value) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'min_basket_value'])
        </div>
    </div>

    <div class="form-group">
        <label for="max_basket_value" class="col-sm-2 control-label">
            {{ trans('Max Basket Value') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="max_basket_value"
                   id="max_basket_value"
                   placeholder="{{ trans('Max Basket Value') }}"
                   value="{{ Request::old('max_basket_value', $item->max_basket_value) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'max_basket_value'])
        </div>
    </div>

</div>
