<div class="form-horizontal">

    <div class="form-group">
        <label for="title" class="col-sm-1 control-label">
            {{ trans('fields.title') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="title"
                   id="title"
                   placeholder="{{ trans('fields.title') }}"
                   value="{{ Request::old('title', $item->title) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'title'])
        </div>
    </div>

    <div class="form-group">
        <label for="description" class="col-sm-1 control-label">
            {{ trans('fields.description') }}
        </label>
        <div class="col-sm-11">
            <textarea type="text"
                      class="form-control"
                      name="description"
                      id="description"
                      placeholder="{{ trans('fields.description') }}"
            >{{ Request::old('description', $item->description) }}</textarea>
            @include('core::layouts.partials.admin.field_error', ['field' => 'description'])
        </div>
    </div>

    <div class="form-group">
        <label for="regions" class="col-sm-1 control-label">
            {{ trans('fields.regions') }}
        </label>
        <div class="col-sm-11">
            <select name="regions[]"
                    class="form-control"
                    id="regions"
                    multiple>
                @foreach ($item->_countries as $country)
                    <option value="country_{{ $country->id }}"
                            {{ $item->countries->where('id', $country->id)->isEmpty() ? '' : 'selected' }}>
                        {{ $country->name }} (Country)
                    </option>

                    @foreach ($country->states->where('status', '1') as $state)
                        <option value="state_{{ $state->id}}"
                                {{ $item->states->where('id', $country->id)->isEmpty() ? '' : 'selected' }}>
                            {{ $state->name . ', ' . $country->name }} (State)
                        </option>
                    @endforeach
                @endforeach
            </select>
        </div>
    </div>

    <h3>Methods</h3>
    <table class="table table-striped">
        <thead>
        <tr>
            <th>Name</th>
            <th>Details</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        @foreach(Event::fire('shop.shipping_methods') as $method)
            @if ($method->isManageable())
                <tr>
                    <th>
                        {{ $method->title }}
                    </th>
                    <td>
                        @foreach ($method->getCostBreakdown($item->id) as $method_rate)
                            {{ $method_rate->title }}<br/>
                        @endforeach
                    </td>
                    <td>
                        <a href="{{ $method->manageUrl($item->id) }}" class="btn btn-primary">
                            Manage / Add
                        </a>
                    </td>
                </tr>
            @endif
        @endforeach
        </tbody>
    </table>
</div>
