<?php
/**
 * Class CreateShippingFlatRatesTable
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateShippingFlatRatesTable
 *
 * Set up table for flat rates
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CreateShippingFlatRatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('shipping_flat_rates', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->integer('value')->default(0);
            $table->integer('min_basket_value')->default(0);
            $table->integer('max_basket_value')->nullable()->default(null);
            $table->integer('shipping_zone_id')->unsigned()->index();
            $table->timestamps();

            $table->foreign('shipping_zone_id')
                ->references('id')
                ->on('shipping_zones')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $tables = [
            'shipping_flat_rates',
            'country_state_shipping_zone',
            'country_shipping_zone',
            'shipping_zones',
        ];

        foreach ($tables as $table) {
            Schema::dropIfExists($table);
        }
    }
}
